<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if( !class_exists( 'mts_testimonials_widget' ) ){
	class mts_testimonials_widget extends WP_Widget {

		public function __construct() {
			parent::__construct(
		 		'mts_testimonials_widget',
				__('Testimonials', 'mts-testimonials'),
				array( 'description' => __( 'Display testimonials.', 'mts-testimonials' ) )
			);
		}

	 	public function form( $instance ) {
	 		global $mts_testimonials;
			$defaults = array(
				'title' => '',
				'layout' => 'bubble_grid',
				'category' => '0',
				'number' => 3,
				'order_by' => 'rand',
				'color_scheme' => '',
				'show_title' => 1,
				'show_image' => 1,
				'show_position' => 1,
				'show_rating' => 1,
				'carousel_transition' => 3,
				'shortcode' => ''
			);
			$instance = wp_parse_args((array) $instance, $defaults);
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'mts-testimonials' ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'layout' ); ?>"><?php _e( 'Layout:', 'mts-testimonials' ); ?></label>
				<?php echo $mts_testimonials->layouts_dropdown($this->get_field_name( 'layout' ), $instance['layout'], $this->get_field_id( 'layout' ), 'widefat'); ?>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'Category:', 'mts-testimonials' ); ?></label><br />
				<?php wp_dropdown_categories( Array(
							'orderby'            => 'ID',
							'order'              => 'ASC',
							'show_count'         => 1,
							'hide_empty'         => 0,
							'hide_if_empty'      => false,
							'echo'               => 1,
							'selected'           => $instance['category'],
							'hierarchical'       => 1,
							'name'               => $this->get_field_name( 'category' ),
							'id'                 => $this->get_field_id( 'category' ),
							'taxonomy'           => 'mts_testimonials_category',
							'show_option_all' 	 => __('Any', 'mts-testimonials')
						) ); ?>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of testimonials to show:', 'mts-testimonials' ); ?></label><br />
				<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" min="-1" step="1" value="<?php echo esc_attr( $instance['number'] ); ?>" class="small-text" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('order_by'); ?>"><?php _e('Order:', 'mts-testimonials'); ?></label><br />
				<select id="<?php echo $this->get_field_id('order_by'); ?>" name="<?php echo $this->get_field_name('order_by'); ?>">
					<option value="rand" <?php selected($instance['order_by'], 'rand', true); ?>><?php _e('Random', 'mts-testimonials'); ?></option>
					<option value="date" <?php selected($instance['order_by'], 'date', true); ?>><?php _e('Latest', 'mts-testimonials'); ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'color_scheme' ); ?>"><?php _e( 'Color Scheme:', 'mts-testimonials' ); ?></label><br />
				<input id="<?php echo $this->get_field_id( 'color_scheme' ); ?>" name="<?php echo $this->get_field_name( 'color_scheme' ); ?>" type="text" value="<?php echo esc_attr( $instance['color_scheme'] ); ?>" class="testimonial-widget-color" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id("show_title"); ?>">
					<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_title"); ?>" name="<?php echo $this->get_field_name("show_title"); ?>" value="1" <?php checked( 1, $instance['show_title'], true ); ?> />
					<?php _e( 'Show title of the testimonial', 'mts-testimonials'); ?>
				</label>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id("show_image"); ?>">
					<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_image"); ?>" name="<?php echo $this->get_field_name("show_image"); ?>" value="1" <?php checked( 1, $instance['show_image'], true ); ?> />
					<?php _e( 'Show image', 'mts-testimonials'); ?>
				</label>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id("show_position"); ?>">
					<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_position"); ?>" name="<?php echo $this->get_field_name("show_position"); ?>" value="1" <?php checked( 1, $instance['show_position'], true ); ?> />
					<?php _e( 'Show position of the person', 'mts-testimonials'); ?>
				</label>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id("show_rating"); ?>">
					<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_rating"); ?>" name="<?php echo $this->get_field_name("show_rating"); ?>" value="1" <?php checked( 1, $instance['show_rating'], true ); ?> />
					<?php _e( 'Show rating', 'mts-testimonials'); ?>
				</label>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'carousel_transition' ); ?>"><?php _e( 'Carousel Transition (Seconds):', 'mts-testimonials' ); ?></label><br />
				<input id="<?php echo $this->get_field_id( 'carousel_transition' ); ?>" name="<?php echo $this->get_field_name( 'carousel_transition' ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $instance['carousel_transition'] ); ?>" class="small-text" />
			</p>
			<p class="description" style="padding-top: 12px;border-top: 1px solid #ddd;">
				<label for="<?php echo $this->get_field_id( 'shortcode' ); ?>"><?php _e( 'Or Insert Shortcode:', 'mts-testimonials' ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'shortcode' ); ?>" name="<?php echo $this->get_field_name( 'shortcode' ); ?>" type="text" value="<?php echo esc_attr( $instance['shortcode'] ); ?>" />
				<?php _e( 'Inserting a shortcode will override above options.', 'mts-testimonials' ); ?>
			</p>
			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['layout'] = strip_tags( $new_instance['layout'] );
			$instance['category'] = intval( $new_instance['category'] );
			$instance['number'] = intval( $new_instance['number'] );
			$instance['order_by'] = strip_tags( $new_instance['order_by'] );
			$instance['color_scheme'] = strip_tags( $new_instance['color_scheme'] );
			$instance['show_image'] = intval( $new_instance['show_image'] );
			$instance['show_rating'] = intval( $new_instance['show_rating'] );
			$instance['carousel_transition'] = intval( $new_instance['carousel_transition'] );
			$instance['shortcode'] = strip_tags( $new_instance['shortcode'] );
			return $instance;
		}

		public function widget( $args, $instance ) {
			extract( $args );
			$title = apply_filters( 'widget_title', $instance['title'] );
			$shortcode = '[mts_testimonial';
			foreach ($instance as $attr_name => $attr_value) {
				$shortcode .= ' '.$attr_name.'="'.$attr_value.'"';
			}
			$shortcode .= ']';
			if (isset($instance['shortcode'])) {
				$shortcode_option = trim($instance['shortcode']);
				if (!empty($shortcode_option))
					$shortcode = $shortcode_option;
			}

			$before_widget = preg_replace('/class="([^"]+)"/i', 'class="$1 '.(isset($instance['box_layout']) ? $instance['box_layout'] : 'horizontal-small').'"', $before_widget); // Add horizontal/vertical class to widget
			echo $before_widget;
			if ( ! empty( $title ) ) echo $before_title . $title . $after_title;
			echo do_shortcode($shortcode);
			echo $after_widget;
		}

	}
}
// add scripts
add_action('admin_enqueue_scripts', 'mts_testimonials_widget_script');
add_action('customize_controls_enqueue_scripts', 'mts_testimonials_widget_script');
function mts_testimonials_widget_script() {
    $screen = get_current_screen();
    $screen_id = $screen->id;
    $current_filter = current_filter();
    if ( 'widgets' == $screen_id || 'customize_controls_enqueue_scripts' === $current_filter ) {
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'mts_testimonials_widget', MTS_TESTIMONIALS_URL . '/assets/js/testimonial-widget.js', array( 'wp-color-picker' ) );
    }
}

// Register widget
add_action( 'widgets_init', 'mts_testimonials_register_widget' );
function mts_testimonials_register_widget() {
	register_widget( 'mts_testimonials_widget' );
}
